;Copyright  1999  by Henter-Joyce, Inc.
;Script File for the MicroSoft Net Meeting
;written by J.C

Include "hjconst.jsh"
Include "hjglobal.jsh"
Include "conf.jsh"
Include "conf.jsm"

Function AutoStartEvent ()
var
  int IVerbosity
  let IVerbosity = GetVerbosity ()
If (NetMeetingFirstTime == 0) then
  let NetMeetingFirstTime = 1
If (IVerbosity == beginner) then
  Say (msg1, ot_help)
  Say (msg2, ot_help)
  Say (msg3, ot_help)
EndIf
EndIf
EndFunction

Script ScriptFileName ()
ScriptAndAppNames (msg4)
EndScript

Script WindowKeysHelp ()
  Say (msg5, ot_help)
  Say (msg6, ot_help)  
  Say (msg7, ot_help)
  Say (msg8, ot_help)
  Say (msg9, ot_help)
  Say (msg10, ot_help)
  Say (msg11, ot_help)
  Say (msg12, ot_help)
  Say (msg13, ot_help)
EndScript

Script ClickHistoryListButton ()
var 
  handle HFocus
  let HFocus = GetFocus ()
If (FindGraphic(HFocus, msg14, s_bottom, s_unrestricted)) then
  LeftMouseButton ()
Else
  Say (msg18, ot_message)
  PcCursor ()
  Return
EndIf
  PcCursor ()
EndScript

Script ClickCurrentCallButton ()
var
  handle HFocus
  let HFocus = GetFocus ()
If (FindGraphic(HFocus, msg15, s_bottom, s_unrestricted)) then
  LeftMouseButton ()
Else 
  Say (msg19, ot_message)
  PcCursor ()
  Return
EndIf
  PcCursor ()
EndScript

Script ClickSpeedDialButton ()
var
  handle HFocus
  let HFocus = GetFocus ()
If (FindGraphic(HFocus, msg16, s_bottom, s_unrestricted)) then
  LeftMouseButton ()
Else
  Say (msg20, ot_message)
  PcCursor ()
  Return
EndIf
  PcCursor ()
EndScript

Script ClickDirectoryButton ()
var 
  handle HFocus 
  let HFocus = GetFocus ()
IF (FindGraphic(HFocus, msg17, s_bottom, s_unrestricted)) then
  LeftMouseButton ()
Else
  Say (msg21, ot_message)
  PcCursor ()
  Return 
EndIf
  PcCursor ()
EndScript

Script MicrophoneOnOffToggle ()
var
  handle WindowHandle 
  let WindowHandle = FindDescendantWindow (GetParent (GetParent (GetFocus ())), cbx_microphone)
If (WindowHandle) then
  MoveToWindow (WindowHandle)
  SpeechOff ()
  LeftMouseButton ()
  PcCursor ()
  Pause ()
  SpeechOn ()
If (ControlCanBeChecked ()) then
  Pause ()
EndIf
If (ControlIsChecked ()) then
  Say (msg26, ot_message)
Else
  Say (msg27, ot_message)
EndIf
  Return
EndIf
EndScript

Script SpeakersOnOffToggle ()
var
  handle WindowHandle 
  let WindowHandle = FindDescendantWindow (GetParent (GetParent (GetFocus ())), cbx_speakers)
If (WindowHandle) then
  MoveToWindow (WindowHandle)
  SpeechOff ()
  LeftMouseButton ()
  PcCursor ()
  Pause ()
  SpeechOn ()
If (ControlCanBeChecked ()) then
  Pause ()
EndIf
If (ControlIsChecked ()) then
  Say (msg28, ot_message)
Else
  Say (msg29, ot_message)
EndIf
  Return
EndIf
EndScript

Script MicrophoneVolume ()
var
  handle WindowHandle 
  let WindowHandle = FindDescendantWindow (GetTopLevelWindow (GetFocus ()), sldr_microphone)
If (WindowHandle) then
  MoveToWindow (WindowHandle)
  PcCursor ()
  RoutePcToJaws ()
  Delay (2)
Else
  Say (msg31, ot_message)
EndIf
EndScript

Script SpeakersVolume ()
var
  handle WindowHandle 
  let WindowHandle = FindDescendantWindow (GetTopLevelWindow (GetFocus ()), sldr_speakers)
If (WindowHandle) then
  MoveToWindow (WindowHandle)
  PcCursor ()
  RoutePcToJaws ()
  Delay (2)
Else
  Say (msg33, ot_message)
EndIf
EndScript

Function SayFocusedWindow ()
var
  int IControlID 
  let IControlID = GetControlID (GetFocus ())
If (IControlID == sldr_microphone || IControlID == sldr_speakers 
|| IControlID == cbx_microphone || IControlID == cbx_speakers
|| IControlId == lvw_directory || IcontrolID == lvw_history
|| IControlID == lvw_speeddial || lvw_currentcall) then
  PerformScript SayWindowPromptAndText ()
  Return
EndIf
  SayFocusedWindow ()
EndFunction

Script NetMeetingDialogList ()
var
  int Item
  let Item = DLGSelectItemInList (DialogList, DialogListName, false)

  let nSuppressEcho = true
  Delay (2)
If (Item == historyList) then
  PerformScript ClickHistoryListButton ()
ElIf (Item == SpeedDialList) then
  PerformScript ClickSpeedDialButton ()
ElIf (Item == CurrentCallList) then
  PerformScript ClickCurrentCallButton ()
ElIf (Item == DirectoryList) then
  PerformScript ClickDirectoryButton ()
ElIf (Item == MicrophoneOnOff) then
  PerformScript MicrophoneOnOffToggle ()
ElIf (Item == SpeakersOnOff) then
  PerformScript SpeakersOnOffToggle ()
ElIf (Item == MicrophoneVol) then
  PerformScript MicrophoneVolume ()
ElIf (Item == SpeakersVol) then
  PerformScript SpeakersVolume ()
ElIf (Item == SynthMute) then
  PerformScript MuteSynthesizer ()
EndIf
  let nSuppressEcho = false
EndScript

Script SayLine ()
var
  int IControlID	
  Let IControlID = GetControlID (GetFocus ())
If (IControlID == cbx_microphone) then
  Say (msg34, ot_control_name)
ElIf (IControlID == cbx_speakers) then
  Say (msg35, ot_control_name)
ElIf (IControlID == sldr_microphone) then
  Say (msg30, ot_control_name)
ElIf (IControlID == sldr_speakers) then
  Say (msg32, ot_control_name)
EndIf
  PerformScript SayLine ()
EndScript

Script SayWindowPromptAndText ()
var
  int IControlID	
  Let IControlID = GetControlID (GetFocus ())
If (IControlID == cbx_microphone) then
  Say (msg34, ot_control_name)
ElIf (IControlID == cbx_speakers) then
  Say (msg35, ot_control_name)
ElIf (IControlID == sldr_microphone) then
  Say (msg30, ot_control_name)
ElIf (IControlID == sldr_speakers) then
  Say (msg32, ot_control_name)
ElIf (IControlId == lvw_directory) then
  say (msg22, ot_control_name)
ElIf (IcontrolID == lvw_speeddial) then
  Say (msg23, ot_control_name)
ElIf (IcontrolID == lvw_currentcall) then
  Say (msg24, ot_control_name)
ElIf (IControlId == lvw_history) then
  Say (msg25, ot_control_name)
EndIf
  PerformScript SayWindowPromptAndText ()
EndScript

Script HotKeyHelp ()
  Say (msg36 + GetScriptKeyName ("ClickHistoryListButton"), ot_help)
  Say (msg37 + GetScriptKeyName ("ClickCurrentCallButton"), ot_help)
  Say (msg38 + GetScriptKeyName ("ClickSpeedDialButton"), ot_help)
  Say (msg39 + GetScriptKeyName ("ClickDirectoryButton"), ot_help)
  Say (msg40 + GetScriptKeyName ("MicrophoneOnOffToggle"), ot_help)
  Say (msg41 +  GetScriptKeyName ("MicrophoneVolume"), ot_help)
  Say (msg42 + GetScriptKeyName ("SpeakersOnOffToggle"), ot_help)
  Say (msg43 + GetScriptKeyName ("SpeakersVolume"), ot_help)
  Say (msg44 + GetScriptKeyName ("NetMeetingDialogList"), ot_help)  
  Say (msg45, ot_help)
EndScript

Script ScreenSensitiveHelp ()
var
  int IControlId
If (IsSameScript ()) then
	AppFileTopic ()
	Return
EndIf
  let IControlID = getControlID (GetFocus ()) 
If (IControlID == cbx_microphone) then
  Say (msg46, ot_help)
  Say (msg47, ot_help)
  Say (msg48, ot_help)
  Say (msg49, ot_help)
  Return
Elif (IControlID == cbx_speakers) then
  Say (msg50, ot_help)
  Say (msg47, ot_help)
  Say (msg48, ot_help)
  Say (msg49, ot_help)
  Return
ElIf (IControlID == sldr_microphone) then
  Say(msg51, ot_help)
ElIF (IControlID == sldr_speakers) then
  Say (msg52, ot_help)
elIF (IControlID == lvw_history) then
  Say (msg53, ot_help)
    Say (msg57, ot_help)
  Say (msg58, ot_help)
  Say (msg59, ot_help)
  Say (msg60, ot_help)
  Say (msg61, ot_help)
  Say (msg62, ot_help)
  Say (msg63, ot_help)
  Say (msg64, ot_help)
  Say (msg65, ot_help)
  Say (msg66, ot_help)
  Say (msg67, ot_help)
  Return
elIf (IControlID == lvw_directory) then
  Say (msg56, ot_help)
      Say (msg57, ot_help)
  Say (msg58, ot_help)
  Say (msg59, ot_help)
  Say (msg60, ot_help)
  Say (msg61, ot_help)
  Say (msg62, ot_help)
  Say (msg63, ot_help)
  Say (msg64, ot_help)
  Say (msg65, ot_help)
  Say (msg66, ot_help)
  Say (msg67, ot_help)
  Return
ElIf (IControlID == lvw_speeddial) then
  Say (msg54, ot_help)
      Say (msg57, ot_help)
  Say (msg58, ot_help)
  Say (msg59, ot_help)
  Say (msg60, ot_help)
  Say (msg61, ot_help)
  Say (msg62, ot_help)
  Say (msg63, ot_help)
  Say (msg64, ot_help)
  Say (msg65, ot_help)
  Say (msg66, ot_help)
  Say (msg67, ot_help)
  Return
ElIF (IControlID == lvw_currentcall) then
  Say (msg55, ot_help)
      Say (msg57, ot_help)
  Say (msg58, ot_help)
  Say (msg59, ot_help)
  Say (msg60, ot_help)
  Say (msg61, ot_help)
  Say (msg62, ot_help)
  Say (msg63, ot_help)
  Say (msg64, ot_help)
  Say (msg65, ot_help)
  Say (msg66, ot_help)
  Say (msg67, ot_help)
  Return
EndIf
  PerformScript ScreenSensitiveHelp ()
EndScript
